/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.client.gui.widget;

import appeng.client.gui.AEBaseScreen;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.scene.CameraSettings;
import appeng.client.guidebook.scene.GuidebookLevelRenderer;
import appeng.client.guidebook.scene.GuidebookScene;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import com.github.glodblock.extendedae.util.Ae2ReflectClient;
import com.github.glodblock.extendedae.util.FCUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import net.minecraft.class_1041;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_364;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6382;
import net.minecraft.class_6575;
import org.jetbrains.annotations.NotNull;

public class WorldDisplay
extends class_339 {
    private final AEBaseScreen<?> addedOn;
    private float zoom = 2.0f;
    private GuidebookScene scene;
    private boolean ready;
    private boolean hideNeighbor;
    @NotNull
    private static final class_1937 clientWorld;
    private static final GuidebookLevelRenderer worldRender;
    private LytRect bounds;

    public WorldDisplay(AEBaseScreen<?> addedOn, int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.addedOn = addedOn;
        this.ready = false;
        this.hideNeighbor = false;
    }

    public void unload() {
        this.ready = false;
    }

    public void setHideNeighbor(boolean val) {
        this.hideNeighbor = val;
    }

    public void locate(class_2338 blockPos) {
        this.zoom = 2.0f;
        this.ready = false;
        class_2680 block = clientWorld.method_8320(blockPos);
        class_2586 te = clientWorld.method_8321(blockPos);
        if (block.method_26215() || te == null) {
            return;
        }
        this.scene = new GuidebookScene(new GuidebookLevel(), new CameraSettings());
        class_5425 wrap = Ae2ReflectClient.getFakeServerWorld((class_1936)this.scene.getLevel());
        assert (wrap != null);
        class_2382 sizeX = new class_2382(3, 1, 1);
        class_2382 sizeY = new class_2382(1, 3, 1);
        class_2382 sizeZ = new class_2382(1, 1, 3);
        class_2338 startX = class_2338.field_10980.method_10069(0, 1, 1);
        class_2338 startY = class_2338.field_10980.method_10069(1, 0, 1);
        class_2338 startZ = class_2338.field_10980.method_10069(1, 1, 0);
        class_3499 tmp = new class_3499();
        class_3492 settings = new class_3492();
        class_6575 random = new class_6575(0L);
        settings.method_15133(true);
        if (this.hideNeighbor) {
            tmp.method_15174(clientWorld, blockPos, new class_2382(1, 1, 1), false, class_2246.field_10124);
            tmp.method_15172(wrap, new class_2338(1, 1, 1), class_2338.field_10980, settings, (class_5819)random, 0);
        } else {
            tmp.method_15174(clientWorld, blockPos.method_10069(-1, 0, 0), sizeX, false, class_2246.field_10124);
            tmp.method_15172(wrap, startX, class_2338.field_10980, settings, (class_5819)random, 0);
            tmp = new class_3499();
            tmp.method_15174(clientWorld, blockPos.method_10069(0, -1, 0), sizeY, false, class_2246.field_10124);
            tmp.method_15172(wrap, startY, class_2338.field_10980, settings, (class_5819)random, 0);
            tmp = new class_3499();
            tmp.method_15174(clientWorld, blockPos.method_10069(0, 0, -1), sizeZ, false, class_2246.field_10124);
            tmp.method_15172(wrap, startZ, class_2338.field_10980, settings, (class_5819)random, 0);
        }
        this.scene.getCameraSettings().setRotationCenter(this.scene.getWorldCenter());
        this.scene.getCameraSettings().setZoom(this.zoom);
        this.bounds = new LytRect(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        this.scene.getCameraSettings().setViewportSize(this.bounds.size());
        this.scene.centerScene();
        this.ready = true;
    }

    public void refreshBounds() {
        this.bounds = new LytRect(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
    }

    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.ready) {
            if (this.method_25405(mouseX, mouseY)) {
                this.addedOn.method_25395((class_364)this);
            }
            class_1041 window = class_310.method_1551().method_22683();
            LytRect viewport = this.bounds.transform(guiGraphics.method_51448().method_23760().method_23761());
            RenderSystem.viewport((int)((int)((double)viewport.x() * window.method_4495())), (int)((int)((double)window.method_4506() - (double)viewport.bottom() * window.method_4495())), (int)((int)((double)viewport.width() * window.method_4495())), (int)((int)((double)viewport.height() * window.method_4495())));
            guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
            worldRender.render(this.scene.getLevel(), this.scene.getCameraSettings(), Collections.emptyList());
            guiGraphics.method_44380();
            RenderSystem.viewport((int)0, (int)0, (int)window.method_4489(), (int)window.method_4506());
        }
    }

    protected void method_47399(@NotNull class_6382 pNarrationElementOutput) {
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.field_22764 && this.ready && this.method_25405(pMouseX, pMouseY)) {
            float dx = (float)pDragX;
            float dy = (float)pDragY;
            CameraSettings camera = this.scene.getCameraSettings();
            if (pButton == 0) {
                camera.setRotationY(camera.getRotationY() + dx);
                camera.setRotationX(camera.getRotationX() + dy);
            } else if (pButton == 1) {
                camera.setOffsetX(camera.getOffsetX() + dx);
                camera.setOffsetY(camera.getOffsetY() - dy);
            }
        }
        return false;
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (this.field_22764 && this.ready && this.method_25405(pMouseX, pMouseY)) {
            this.zoom = (float)FCUtil.clamp((double)this.zoom + pDelta / 5.0, 0.5, 10.0);
            this.scene.getCameraSettings().setZoom(this.zoom);
            return true;
        }
        return false;
    }

    static {
        worldRender = GuidebookLevelRenderer.getInstance();
        assert (class_310.method_1551().field_1687 != null);
        clientWorld = class_310.method_1551().field_1687;
    }
}

